﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Data;
using System.Configuration;
using System.Data.OleDb;
using System.IO;
using System.Drawing;
using System.Drawing.Imaging;

namespace Matris
{
    //converting between BMP and matris
    public static  class Load
    {

        public static Bitmap BMPfromeMatris2D(ref int[,] matris, int width, int height)
        {
            Bitmap bmp = new Bitmap(width, height);
            for (int i = 0; i < width; i++)
                for (int j = 0; j < height; j++)
                    bmp.SetPixel(i, j, matris[i, j] == 1 ? Color.White : Color.Black);
            return bmp;
        }
        public static Bitmap BMPfromeMatris3D(ref int[, ,] matris, int width, int height)
        {
            Bitmap bmp = new Bitmap(width, height);
            BitmapData data = bmp.LockBits(new Rectangle(0, 0, bmp.Width, bmp.Height), ImageLockMode.WriteOnly, PixelFormat.Format24bppRgb);
            unsafe
            {
                byte* s = (byte*)data.Scan0;
                for (int i = 0; i < data.Height; i++)
                {
                    for (int j = 0; j < data.Width; j++)
                    {
                        s[2] = (byte)matris[j, i, 0];
                        s[1] = (byte)matris[j, i, 1];
                        s[0] = (byte)matris[j, i, 2];
                        s += 3;
                    }
                    s += data.Stride - (data.Width * 3);
                }
            }
            bmp.UnlockBits(data);
            return bmp;
        }
        public static Bitmap BMPfromeMatris2d(ref double[,]imageMatris,int width,int height){
            Bitmap image = new Bitmap(width,height);
            for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                {
                    int tmp = Convert.ToInt32(imageMatris[i, j]);
                    image.SetPixel(i, j, Color.FromArgb(tmp, tmp, tmp));
                }
            return image;
        }

        public static int[,] Matris2DFromeBMPFile(string filename)
        {
            if (!File.Exists(filename) && !File.Exists(filename + ".bmp"))
                return null;

            Bitmap bmp = new Bitmap(filename);
            int width = bmp.Width, height = bmp.Height;
            int[,] matris = new int[width, height];

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    matris[i, j] = (c.R == 0 && c.G == 0 && c.B == 0) ? 0 : 1;
                }
            }

            return matris;
        }
        public static int[, ,] Matris3DFromeBMPFile(string filename)
        {
            if (!File.Exists(filename) && !File.Exists(filename + ".bmp"))
                return null;

            Bitmap bmp = new Bitmap(filename);
            int width = bmp.Width, height = bmp.Height;
            int[, ,] matris = new int[width, height, 3];

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    matris[i, j, 0] = c.R;
                    matris[i, j, 1] = c.G;
                    matris[i, j, 2] = c.B;
                }
            }

            return matris;
        }

        public static int[,] Matris2DFromeBMP(ref Bitmap bmp)
        {
            int width = bmp.Width, height = bmp.Height;
            int[,] matris = new int[width, height];

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    matris[i, j] = (c.R == 0 && c.G == 0 && c.B == 0) ? 0 : 1;
                }
            }

            return matris;
        }
        public static double[,] Matris2DFromeBMP_(ref Bitmap image)
        {
            int width = image.Width, height = image.Height;
            double[,] matris = new double[width, height];

            double inf = 100000000;
            for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                {
                    Color c = image.GetPixel(i, j); //matris[i, j] = c.R > 127 ? inf : 0; }
                    matris[i, j] = c.R > 127 ? 0 : inf;
                }

            return matris;
        }
        public static double[, ,] Matris3dFromeBMP(ref Bitmap image)
        {
            int width = image.Width, height = image.Height;
            double[, ,] matris = new double[width, height, 3];
            BitmapData data = image.LockBits(new Rectangle(0, 0, image.Width, image.Height), ImageLockMode.ReadOnly, PixelFormat.Format32bppArgb);
            unsafe
            {
                byte* startbit = (byte*)data.Scan0;
                for (int i = 0; i < data.Height; i++)
                {
                    for (int j = 0; j < data.Width; j++)
                    {
                        matris[i, j, 0] = (int)startbit[2];
                        matris[i, j, 1] = (int)startbit[1];
                        matris[i, j, 2] = (int)startbit[0];
                        startbit += 4;
                    }
                    startbit += data.Stride - (data.Width * 4);
                }
            }
            image.UnlockBits(data);
            return matris;
        }
        public static int[, ,] Matris3DFromeBMP(Bitmap bmp)
        {
            int width = bmp.Width, height = bmp.Height;
            int[, ,] matris = new int[width, height, 3];

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    matris[i, j, 0] = c.R;
                    matris[i, j, 1] = c.G;
                    matris[i, j, 2] = c.B;
                }
            }

            return matris;
        }
        public static int[, ,] Matris3DFromeBMP_(ref Bitmap bmp)
        {
            int width = bmp.Width, height = bmp.Height;
            int[, ,] matris = new int[width, height, 3];

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    Color c = bmp.GetPixel(i, j);
                    matris[i, j, 0] = c.R;
                    matris[i, j, 1] = c.G;
                    matris[i, j, 2] = c.B;
                }
            }

            return matris;
        }

        public static int[,] Matris2DFromeMatris3D(ref int[, ,] matrsi3d, int width, int height)
        {
            int[,] matris2d = new int[width, height];

            for (int i = 0; i < width; i++)
                for (int j = 0; j < height; j++)
                    matris2d[i, j] = (matrsi3d[i, j, 0] == 0 && matrsi3d[i, j, 1] == 0 && matrsi3d[i, j, 2] == 0) ? 0 : 1;

            return matris2d;
        }
        public static int[,] Matris2DFromeMatris3D(int[, ,] matrsi3d, int width, int height)
        {
            int[,] matris2d = new int[width, height];

            for (int i = 0; i < width; i++)
                for (int j = 0; j < height; j++)
                    matris2d[i, j] = (matrsi3d[i, j, 0] == 0 && matrsi3d[i, j, 1] == 0 && matrsi3d[i, j, 2] == 0) ? 0 : 1;

            return matris2d;
        }
        public static int[, ,] Matris3DFromeMatris2D(ref int[,] matris2d, int width, int height)
        {
            int[, ,] matris3d = new int[width, height, 3];

            for (int i = 0; i < width; i++)
                for (int j = 0; j < height; j++)
                    //matris3d[i, j, 0] = matris3d[i, j, 1] = matris3d[i, j, 2] = matris2d[i, j] == 1 ? 255 : 0;
                    matris3d[i, j, 0] = matris3d[i, j, 1] = matris3d[i, j, 2] = matris2d[i, j];

            return matris3d;
        }
        public static int[, ,] Matris3DFromeMatris2D(int[,] matris2d, int width, int height)
        {
            int[, ,] matris3d = new int[width, height, 3];

            for (int i = 0; i < width; i++)
                for (int j = 0; j < height; j++)
                    //matris3d[i, j, 0] = matris3d[i, j, 1] = matris3d[i, j, 2] = matris2d[i, j] == 1 ? 255 : 0;
                    matris3d[i, j, 0] = matris3d[i, j, 1] = matris3d[i, j, 2] = matris2d[i, j];

            return matris3d;
        }

        public static int[,] NHOODS_3D(ref int[,,] matris, int windiwsize, int x, int y)
        {
            int[,] hoods = new int[windiwsize * windiwsize, 3];
            int halfsize = (windiwsize - 1) / 2;
            int startI = x - halfsize, startJ = y - halfsize;
            int endI = x + halfsize, endJ = y + halfsize;
            for (int i = startI; i <= endI; i++) 
                for (int j = startJ; j <= endJ; j++)
                {
                    hoods[((i - startI) * windiwsize) + j - startJ, 0] = matris[i, j, 0];
                    hoods[((i - startI) * windiwsize) + j - startJ, 1] = matris[i, j, 1];
                    hoods[((i - startI) * windiwsize) + j - startJ, 2] = matris[i, j, 2];
                }
            return hoods;
        }
        public static int[, ,] NHOODS_3D_(ref int [,,]matris, int winsize, int x, int y)
        {
            int[, ,] hoods = new int[winsize, winsize, 3];
            int halfsize = (winsize - 1) / 2;
            int startI = x - halfsize, startJ = y - halfsize;
            int endI = x + halfsize, endJ = y + halfsize;
            for (int i = startI; i <= endI; i++)
                for (int j = startJ; j <= endJ; j++)
                {
                    hoods[i - startI, j - startJ, 0] = matris[i , j, 0];
                    hoods[i - startI, j - startJ, 1] = matris[i , j, 1];
                    hoods[i - startI, j - startJ, 2] = matris[i , j, 2];
                }
            return hoods;
        }
        public static int[] NHOODS_2D(ref int[,] matris, int windiwsize,int x,int y)
        {
            int[] hoods = new int[windiwsize * windiwsize];
            int halfsize = (windiwsize-1)/2;
            int startI=x-halfsize,startJ=y-halfsize;
            int endI=x+halfsize,endJ=y+halfsize;
            for (int i = startI; i <= endI; i++) for (int j = startJ; j <= endJ; j++) hoods[((i-startI) * windiwsize) + j-startJ] = matris[i, j];
            return hoods;
        }
        public static int[] NHOOHS_LAYER_2D(ref int[,] matris, int windiwsize, int x, int y)
        {
            int[] hoods = new int[windiwsize * 4];
            int halfsize = (windiwsize - 1) / 2;
            int startI = x - halfsize, startJ = y - halfsize;
            int endI = x + halfsize, endJ = y + halfsize;
            //top
            int index=0;
            for (int i = startI; i <= endI; i++) hoods[index++] = matris[i, startJ];
            //down
            for (int i = startI; i <= endI; i++) hoods[index++] = matris[i, endJ];
            //right
            for (int j = startJ; j <= endJ; j++) hoods[index++] = matris[endI, j];
            //left
            for (int j = startJ; j <= endJ; j++) hoods[index++] = matris[startI, j];
            return hoods;
        }

    }
    
    //saving BMP and matris into file
    public static class Save
    {
        public static string BMP2BMPFile(string filename, Bitmap bmpfile)
        {
            try
            {
                bmpfile.Save(filename);
                bmpfile.Dispose();
                return filename;
            }
            catch
            {
                return "ERRORE !unknown errore.";
            }
        }
        public static string Matris2DToBMPFile(ref int[,] matris, int width, int height, string filename)
        {
            Bitmap bmp = new Bitmap(width, height);

            for (int i = 0; i < width; i++)
                for (int j = 0; j < height; j++)
                    //bmp.SetPixel(i, j, matris[i, j] == 1 ? Color.White : Color.Black);
                    bmp.SetPixel(i, j, matris[i, j] > 0 ? Color.White : Color.Black);

            bmp.Save(filename);
            bmp.Dispose();
            return filename;
        }
        public static string Matris2DToBMPFile(ref double[,] matris, int width, int height, string filename)
        {
            Bitmap bmp = new Bitmap(width, height);

            for (int i = 0; i < width; i++)for (int j = 0; j < height; j++)
                    bmp.SetPixel(i, j, Color.FromArgb(Convert.ToInt32(matris[i, j]), Convert.ToInt32(matris[i, j]), Convert.ToInt32(matris[i, j])));

            bmp.Save(filename);
            bmp.Dispose();
            return filename;
        }
        public static string Matris3DToBMPFile(ref int[, ,] matris, int width, int height, string filename)
        {
            Bitmap bmp = new Bitmap(width, height);

            for (int i = 0; i < width; i++)
                for (int j = 0; j < height; j++)
                    bmp.SetPixel(i, j, Color.FromArgb(matris[i, j, 0], matris[i, j, 1], matris[i, j, 2]));

            bmp.Save(filename);
            bmp.Dispose();
            return filename;
        }

    }

    //copy, crop, edit
    public static class Edit
    {
        /// <summary>
        /// matris1 = matris2
        /// </summary>
        ///<param name="x">start position</param>
        public static void copy(ref int[,] matris1, int w1, int h1, ref int[,] matris2, int w2, int h2,int x, int y)
        {
            x = x - (w2 - 1) / 2;
            y = y - (h2 - 1) / 2;
            w2 = x + w2;
            h2 = y + h2;
            int width = w1 < w2 ? w1 : w2;
            int height = h1 < h2 ? h1 : h2;
            for (int i = x; i < width; i++) for (int j = y; j < height; j++) matris1[i, j] = matris2[i - x, j - y];
        }//copy
        /// <param name="mat1">dest mat</param>
        /// <param name="mat2">source mat</param>
        public static void copy(ref int[,] mat1, ref int[,] mat2, int w, int h)
        {
            for (int i = 0; i < w; i++) for (int j = 0; j < h; j++) mat1[i, j] = mat2[i, j];
        }
        public static void Copy(ref int[, ,] image1, int w1, int h1, ref int[, ,] image2, int w2, int h2, int xOfs, int yOfs)
        {
            int starti = 0, endi = 0, startj = 0, endj = 0;
            
            if (xOfs < 0 && xOfs > -w2) return;
            if (xOfs < 0) starti = -xOfs;
            if (xOfs > w2) return;
            endi = w1 - xOfs;

            if (yOfs < 0 && yOfs > -h2) return;
            if (yOfs < 0) startj = -yOfs;
            if (yOfs > h2) return;
            endj = h1 - yOfs;

            for (int i = starti; i < endi; i++) for (int j = startj; j < endj; j++) for (int k = 0; k < 3; k++)
                        image1[i + xOfs, j + yOfs, k] = image2[i, j, k];
        }
        public static int[,] Crop(ref int[,] image, int width, int height, int sx, int sy, int ex, int ey)
        {
            int newwidth = ex - sx + 1, newheight = ey - sy + 1;
            int[,] newimage = new int[newwidth, newheight];
            for (int i = sx; i <= ex; i++) for (int j = sy; j <= ey; j++) newimage[i - sx, j - sy] = image[i, j];
            return newimage;
        }
        public static int[, ,] Crop(ref int[, ,] image, int width, int height, int sx, int sy, int ex, int ey)
        {
            int newwidth = ex - sx + 1, newheight = ey - sy + 1;
            int[, ,] newimage = new int[newwidth, newheight,3];
            for (int i = sx; i <= ex; i++)
            {
                for (int j = sy; j <= ey; j++)
                {
                    newimage[i - sx, j - sy, 0] = image[i, j, 0];
                    newimage[i - sx, j - sy, 1] = image[i, j, 1];
                    newimage[i - sx, j - sy, 2] = image[i, j, 2];
                }
            }
            return newimage;
        }
        public static int[, ,] Resize(ref int[, ,] image, int width, int height, double nwidth, double nheight)
        {
            double Wpercentage = nwidth / width, Hpercentage = nheight / height;
            int[, ,] newimage = new int[Convert.ToInt32(nwidth), Convert.ToInt32(nheight), 3];

            for (double i = 0; i < nwidth; i++)
            {
                int i_ = Convert.ToInt16(System.Math.Floor(i / Wpercentage));
                for (double j = 0; j < nheight; j++)
                {
                    int j_ = Convert.ToInt16(System.Math.Floor(j / Hpercentage));
                    int I = Convert.ToInt32(i), J = Convert.ToInt32(j);
                    if (newimage[I, J, 0] == 0) newimage[I, J, 0] = image[i_, j_, 0];
                    else newimage[I, J, 0] = (newimage[I, J, 0] + image[i_, j_, 0]) / 2;
                    if (newimage[I, J, 1] == 0) newimage[I, J, 1] = image[i_, j_, 1];
                    else newimage[I, J, 1] = (newimage[I, J, 1] + image[i_, j_, 1]) / 2;
                    if (newimage[I, J, 2] == 0) newimage[I, J, 2] = image[i_, j_, 2];
                    else newimage[I, J, 2] = (newimage[I, J, 2] + image[i_, j_, 2]) / 2;
                }
            }
            int newWidth = Convert.ToInt32(nwidth), newHeight = Convert.ToInt32(nheight);
            if (newWidth > width || newHeight > height)
            {
                //expand image to cleannoise it better
                newimage = Matris.Edit.ExpandAndCentralize(ref newimage, newWidth, newHeight, 11);
                newimage = Filters.cleannoise(ref newimage, newWidth + 22, newHeight + 22, "avg", 11);
                newimage = Matris.Edit.Crop(ref newimage, newWidth + 22, newHeight + 22, 11, 11, newWidth + 11, newHeight + 11);
            }
            Matris.Math.ApplyThreshold(ref newimage, newWidth, newHeight, 255, 0);

            return newimage;
        }
        /// <summary>
        /// حاشیه سیاه را از تصویر حذف میکند
        /// </summary>
        public static void CentralizeAndDeletBorder(ref int[,] imagematris, int width, int height)
        {
            int[] frame = Histogram.ComponentFrame(ref imagematris, width, height);
            imagematris = Crop(ref imagematris, width, height, frame[0], frame[1], frame[2], frame[3]);
        }
        public static void CentralizeAndDeletBorder(ref int[,] imagematris, int width, int height, ref int[] frame, ref Size size)
        {
            frame = Histogram.ComponentFrame(ref imagematris, width, height);
            size = new Size(frame[2] - frame[0] + 1, frame[3] - frame[1] + 1);
            imagematris = Crop(ref imagematris, width, height, frame[0], frame[1], frame[2], frame[3]);
        }
        public static void CentralizeAndDeletBorder(ref int[, ,] imagematris, int width, int height)
        {
            int[] frame = Histogram.ComponentFrame(ref imagematris, width, height);
            imagematris = Crop(ref imagematris, width, height, frame[0], frame[1], frame[2], frame[3]);
        }
        public static void CentralizeAndDeletBorder(ref int[, ,] imagematris, int width, int height, ref int[] frame, ref Size size)
        {
            frame = Histogram.ComponentFrame(ref imagematris, width, height);
            size = new Size(frame[2] - frame[0] + 1, frame[3] - frame[1] + 1);
            imagematris = Crop(ref imagematris, width, height, frame[0], frame[1], frame[2], frame[3]);
        }
        /// <summary>
        /// تصویر را بزرگتر میکند، و یک حاشیه سیاه به تصویر اظافه میکند
        /// </summary>
        public static int[, ,] ExpandAndCentralize(ref int[, ,] imagematris, int width, int height, int BorderSize)
        {
            int newwidth = width + BorderSize * 2, newheight = height + BorderSize * 2;
            int[, ,] newimage = new int[newwidth, newheight, 3];

            for (int i = BorderSize; i < newwidth - BorderSize; i++)
            {
                for (int j = BorderSize; j < newheight - BorderSize; j++)
                {
                    newimage[i, j, 0] = imagematris[i - BorderSize, j - BorderSize, 0];
                    newimage[i, j, 1] = imagematris[i - BorderSize, j - BorderSize, 1];
                    newimage[i, j, 2] = imagematris[i - BorderSize, j - BorderSize, 2];
                }
            }
            return newimage;
        }
        public static int[,] ExpandAndCentralize(ref int[,] imagematris, int width, int height, int BorderSize)
        {
            int newwidth = width + BorderSize * 2, newheight = height + BorderSize * 2;
            int[,] newimage = new int[newwidth, newheight];

            for (int i = BorderSize; i < newwidth - BorderSize; i++)
            {
                for (int j = BorderSize; j < newheight - BorderSize; j++)
                {
                    newimage[i, j] = imagematris[i - BorderSize, j - BorderSize];
                }
            }
            return newimage;
        }
        /// <summary>
        /// حاشیه تصویر را رنگ میکند
        /// </summary>
        public static void AddBorder(ref int[,] imagematris, int width, int height, int BorderSize,int BorderValue)
        {
            for (int i = 0; i < BorderSize; i++) for (int j = 0; j < height; j++) imagematris[i, j] = BorderValue;
            for (int i = width - BorderSize; i < width; i++) for (int j = 0; j < height; j++) imagematris[i, j] = BorderValue;
            for (int i = 0; i < width; i++) for (int j = 0; j < BorderSize; j++) imagematris[i, j] = BorderValue;
            for (int i = 0; i < width; i++) for (int j = height - BorderSize; j < height; j++) imagematris[i, j] = BorderValue;
        }

        public static void FillSolid(ref int[, ,] image, int width, int height, int x, int y, int xLenth, int yLenth, int[] values)
        {
            int endx = x + xLenth > width ? width : x + xLenth;
            int endy = y + yLenth > height ? height : y + yLenth;

            for (int i = x; i < endx; i++)
            {
                for (int j = y; j < endy; j++)
                {
                    image[i, j, 0] = values[0];
                    image[i, j, 1] = values[1];
                    image[i, j, 2] = values[2];
                }
            }
        }
    }

    //basic math operators, owerflow, apply filter, Threshold, . . .
    public static class Math
    {
        public static void ApplyThreshold(ref int[, ,] matris, int w, int h, int upperThresh, int downerThresh)
        {
            for (int i = 0; i < w; i++) 
                for (int j = 0; j < h; j++) 
                    for (int k = 0; k < 3; k++)
                    {
                        int tmp = matris[i, j, k];
                        matris[i, j, k] = tmp > upperThresh ? upperThresh : tmp < downerThresh ? downerThresh : tmp;
                    }
        }
        public static int[,] ApplyBinaryThreshold(ref int[, ,] matris, int w, int h, int upperThresh, int downerThresh)
        {
            int[,] ret = new int[w, h];
            for (int i = 0; i < w; i++)
                for (int j = 0; j < h; j++)
                    ret[i, j] =
                        ((matris[i, j, 0] + matris[i, j, 1] + matris[i, j, 2]) / 3 >= downerThresh) &&
                        ((matris[i, j, 0] + matris[i, j, 1] + matris[i, j, 2]) / 3 <= upperThresh) ?
                        1 : 0;
            return ret;
        }
        public static void ApplyThreshold(ref double[, ,] matris, int w, int h, int upperThresh, int downerThresh)
        {
            for (int i = 0; i < w; i++)
                for (int j = 0; j < h; j++)
                    for (int k = 0; k < 3; k++)
                    {
                        double tmp = matris[i, j, k];
                        matris[i, j, k] = tmp > upperThresh ? upperThresh : tmp < downerThresh ? downerThresh : tmp;
                    }
        }
        public static void ApplyThreshold(ref int[,] matris, int w, int h, int upperThresh, int downerThresh)
        {
            for (int i = 0; i < w; i++)
                for (int j = 0; j < h; j++)
                {
                    int tmp = matris[i, j];
                    matris[i, j] = tmp > upperThresh ? upperThresh : tmp < downerThresh ? downerThresh : tmp;
                }
        }
        public static void ApplyThreshold(ref double[,] matris, int w, int h, int upperThresh, int downerThresh)
        {
            for (int i = 0; i < w; i++)
                for (int j = 0; j < h; j++)
                {
                    double tmp = matris[i, j];
                    matris[i, j] = tmp > upperThresh ? upperThresh : tmp < downerThresh ? downerThresh : tmp;
                }
        }
        public static void ShowFlow(ref int[, ,] mainmatris, ref int[, ,] newmatris, int w, int h, int upperThresh, int downerThresh)
        {
            for (int i = 0; i < w; i++)
                for (int j = 0; j < h; j++)
                    for (int k = 0; k < 3; k++)
                    {
                        int tmp = newmatris[i, j, k];
                        newmatris[i, j, k] = tmp > upperThresh ? mainmatris[i, j, k] : tmp < downerThresh ? mainmatris[i, j, k] : tmp;
                    }
        }
        public static void ShowFlow(ref int[,] mainmatris, ref int[,] newmatris, int w, int h, int upperThresh, int downerThresh)
        {
            for (int i = 0; i < w; i++)
                for (int j = 0; j < h; j++)
                {
                    int tmp = newmatris[i, j];
                    newmatris[i, j] = tmp > upperThresh ? mainmatris[i, j] : tmp < downerThresh ? mainmatris[i, j] : tmp;
                }
        }
        public static void devide(ref int[, ,] matris, int w, int h, int dev)
        {
            if (dev == 0) return;
            for (int i = 0; i < w; i++) for (int j = 0; j < h; j++) for (int k = 0; k < 3; k++) matris[i, j, k] /= dev;
        }
        public static void devide(ref int[,] matris, int w, int h, int dev)
        {
            if (dev == 0) return;
            for (int i = 0; i < w; i++) for (int j = 0; j < h; j++) matris[i, j] /= dev;
        }
        public static void mull(ref int[, ,] matris, int w, int h, double mull)
        {
            for (int i = 0; i < w; i++) for (int j = 0; j < h; j++) for (int k = 0; k < 3; k++)
                        matris[i, j, k] = Convert.ToInt32(matris[i, j, k] * mull);
        }
        public static void mull(ref int[,] matris, int w, int h, double mull)
        {
            for (int i = 0; i < w; i++) for (int j = 0; j < h; j++)
                    matris[i, j] = Convert.ToInt32(matris[i, j] * mull);
        }
        public static void add(ref int[, ,] matris, int w, int h, int add)
        {
            for (int i = 0; i < w; i++) for (int j = 0; j < h; j++) for (int k = 0; k < 3; k++) matris[i, j, k] += add;
        }
        public static void add(ref int[,] matris, int w, int h, int add)
        {
            for (int i = 0; i < w; i++) for (int j = 0; j < h; j++) matris[i, j] += add;
        }
        public static int[,] Add(int[,] mat1, int[,] mat2, int w, int h)
        {
            int[,]rezult=new int[w,h];
            for (int i = 0; i < w; i++) for (int j = 0; j < h; j++) rezult[i, j] = mat1[i, j] + mat2[i, j];
            return rezult;
        }
        public static int[,] Sub(int[,] mat1, int[,] mat2, int w, int h)
        {
            int[,] rezult = new int[w, h];
            for (int i = 0; i < w; i++) for (int j = 0; j < h; j++) rezult[i, j] = mat1[i, j] - mat2[i, j];
            return rezult;
        }

        public static void ApplyFilter(ref int[, ,] srcMatris, int width, int height, ref int[, ,] dstMatris, int[, ,] filtermatris, int winsize)
        {
            //first you must add a frame to your srcMatris , you now why!
            srcMatris = Edit.ExpandAndCentralize(ref srcMatris, width, height, 1);
            //if (winsize % 2 != 0 || winsize < 3) throw new Exception("winsize must be >3 and %2=1 !");
            int winrad = winsize >> 1;
            int hoodsSize = winsize * winsize;
            int[,] HOODS;
            int sumr = 0, sumg = 0, sumb = 0;
            int x, y;
            //for (int i = winrad; i < width - winrad; i++)
            for (int i = winrad; i < width + 2 - winrad; i++)
            {
                //for (int j = winrad; j < height - winrad; j++)
                for (int j = winrad; j < height + 2 - winrad; j++)
                {
                    HOODS = Load.NHOODS_3D(ref srcMatris, winsize, i, j);
                    sumr = 0; sumg = 0; sumb = 0;
                    for (int k = 0; k < hoodsSize; k++)
                    {
                        x = k / winsize;
                        y = k % winsize;
                        sumr += HOODS[k, 0] * filtermatris[x, y, 0];
                        sumg += HOODS[k, 1] * filtermatris[x, y, 1];
                        sumb += HOODS[k, 2] * filtermatris[x, y, 2];
                    }
                    dstMatris[i - 1, j - 1, 0] = sumr;
                    dstMatris[i - 1, j - 1, 1] = sumg;
                    dstMatris[i - 1, j - 1, 2] = sumb;
                }//j
            }//i
            srcMatris = Edit.Crop(ref srcMatris, width + 2, height + 2, 1, 1, width + 1, height + 1);
            //ApplyThreshold(ref dstMatris, width, height, 255, 0);
        }//applyFilter
        
        public static void Scale(ref int[,] image,int width,int height)
        {
            double max = double.MinValue, min = double.MaxValue;
            for (int i = 1; i < width; i++) for (int j = 1; j < height; j++)
                { double tmp = image[i, j]; if (tmp > max)max = tmp; if (tmp < min)min = tmp; }
            double scale = 255 / (max - min);
            for (int i = 1; i < width; i++) for (int j = 1; j < height; j++)
                    image[i, j] = Convert.ToInt32((image[i, j] - min) * scale);
        }
        public static void Scale(ref double[,] image, int width, int height)
        {
            double max = double.MinValue, min = double.MaxValue;
            for (int i = 1; i < width; i++) for (int j = 1; j < height; j++)
                { double tmp = image[i, j]; if (tmp > max)max = tmp; if (tmp < min)min = tmp; }
            double scale = 255 / (max - min);
            for (int i = 1; i < width; i++) for (int j = 1; j < height; j++)
                    image[i, j] = (image[i, j] - min) * scale;
        }
        public static void Scale(ref int[, ,] matris, int width, int height, double r, double g, double b)
        {
            for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                    matris[i, j, 0] = matris[i, j, 1] = matris[i, j, 2] =
                        Convert.ToInt32(matris[i, j, 0] * r + matris[i, j, 1] * g + matris[i, j, 2] * b);
        }
        public static void SingelScaling(ref int[, ,] imagematris, int width, int height, double rz, double rj, double gz, double gj, double bz, double bj)
        {
            int[,,] newimagematris = new int[width,height,3];
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    int r = Convert.ToInt32(imagematris[i, j, 0] * rz + rj);
                    newimagematris[i, j, 0] = r < 0 ? 0 : r > 255 ? 255 : r;
                    int g = Convert.ToInt32(imagematris[i, j, 0] * gz + gj);
                    newimagematris[i, j, 1] = g < 0 ? 0 : g > 255 ? 255 : g;
                    int b = Convert.ToInt32(imagematris[i, j, 0] * bz + bj);
                    newimagematris[i, j, 2] = b < 0 ? 0 : b > 255 ? 255 : b;
                }
            }
        }

        public static int[] average(ref int[, ,] image, int width, int height, int x, int y, int LenthX, int LenthY) 
        {
            int[] avgs = new int[3];
            int endx = x + LenthX > width ? width : x + LenthX;
            int endy = y + LenthY > height ? height : y + LenthY;

            for (int i = x; i < endx; i++)
            {
                for (int j = y; j < endy; j++)
                {
                    avgs[0] += image[i, j, 0];
                    avgs[1] += image[i, j, 1];
                    avgs[2] += image[i, j, 2];
                }
            }
            int sumP = (endx - x) * (endy - y);
            sumP = (endx - x) == 0 ? (endy - y) == 0 ? 1 : (endy - y) : sumP;
            avgs[0] /= sumP; avgs[1] /= sumP; avgs[2] /= sumP;
            return avgs;
        }
        public static int[] average_cross(ref int[, ,] image, int width, int height, int x, int y, int crossLenth)
        {
            int rsum = 0, gsum = 0, bsum = 0;
            for (int i = -crossLenth; i < crossLenth; i++)
            {
                if (i + x > 0 && i + x < width && y + i > 0 && y + i < height)
                {
                    rsum += image[x + i, y + i, 0];
                    gsum += image[x + i, y + i, 1];
                    bsum += image[x + i, y + i, 2];
                }
                if (y - i > 0 && y - i < height && x + i > 0 && x +i < width)
                {
                    rsum += image[x + i, y - i, 0];
                    gsum += image[x + i, y - i, 1];
                    bsum += image[x + i, y - i, 2];
                }
            }

            rsum /= crossLenth * 4; gsum /= crossLenth * 4; bsum /= crossLenth * 4;
            rsum = rsum > 255 ? 255 : rsum; gsum = gsum > 255 ? 255 : gsum; bsum = bsum > 255 ? 255 : bsum;

            return new int[] { rsum, gsum, bsum };
        }
        public static int[] average_Border(ref int[, ,] image, int width, int height, int x, int y, int borderSize)
        {
            if (borderSize < 3)
                return new int[] { 0, 0, 0 };
                //throw new Exception("ERRORE : borderSize mus be >= 3  .");

            int rsum = 0, gsum = 0, bsum = 0;

            int sx = (int)System.Math.Max(x - borderSize / 2, 0),
                ex = (int)System.Math.Min(x + borderSize / 2 - 1, width - 1),
                sy = (int)System.Math.Max(y - borderSize / 2, 0),
                ey = (int)System.Math.Min(y + borderSize / 2 - 1, height - 1);
            for (int i = sx; i < ex; i++)
            {
                rsum += image[i, sy, 0] + image[i, ey, 0];
                gsum += image[i, sy, 1] + image[i, ey, 1];
                bsum += image[i, sy, 2] + image[i, ey, 2];
            }
            for (int j = sy ; j < ey ; j++)
            {
                rsum += image[sx, j, 0] + image[ex, j, 0];
                gsum += image[sx, j, 1] + image[ex, j, 1];
                bsum += image[sx, j, 2] + image[ex, j, 2];
            }


            rsum /= (borderSize * 4) - 4;
            gsum /= (borderSize * 4) - 4;
            bsum /= (borderSize * 4) - 4;

            rsum = rsum > 255 ? 255 : rsum;
            gsum = gsum > 255 ? 255 : gsum;
            bsum = bsum > 255 ? 255 : bsum;

            return new int[] { rsum, gsum, bsum };
        }
    }

    public static class Create
    {
        /// <summary>
        /// ماتریسی که تماما با 1 پرشده
        /// </summary>
        public static int[,] ones(int size)
        {
            int[,] One = new int[size,size];
            for (int i = 0; i < size; i++) for (int j = 0; j < size; j++) One[i, j] = 1;
            return One;
        }
        /// <summary>
        /// ماتریسی که در آن یک مستطیل دور کامپوننت موجود میکشد و داخل آن را 1 میکند
        /// </summary>
        public static int[,] FillFrameOfComponent(ref int[,] imagematris, int width, int height)
        {
            int[,] newimage = new int[width, height];
            int[] frame = Histogram.ComponentFrame(ref imagematris, width, height);
            for (int i = frame[0]; i <= frame[2]; i++) for (int j = frame[1]; j <= frame[3]; j++) newimage[i, j] = 1;
            return newimage;
        }
        public static int[, ,] tst1()
        {
            int[, ,] imagematris_ = new int[256, 256, 3];
            for (int i = 0; i < 256; i++)
            {
                for (int j = 0; j < i; j++)
                    imagematris_[i, j, 0] = imagematris_[i, j, 1] = imagematris_[i, j, 2] = i;/*
                for (int j = i; j < 256; j++)
                    imagematris_[i, j, 0] = imagematris_[i, j, 1] = imagematris_[i, j, 2] = j;*/
            }
            Matris.Math.ApplyThreshold(ref imagematris_, 256, 256, 255, 0);
            return imagematris_;
        }
    }

    public static class Histogram
    {
        /// <summary>
        /// تعداد تکرار سطح های رنگ رو میگه. مثلا میگه فلان تا رنگ با سطح 127 داریم.
        /// </summary>
        /// <returns>آرایه 256 تایی</returns>
        public static int[] Intensity(ref int[,,]image,int width,int height)
        {
            int[] ints = new int[256];

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    ints[image[i, j, 0]]++;
                    ints[image[i, j, 1]]++;
                    ints[image[i, j, 2]]++;
                }
            }

            return ints;
        }
        /// <summary>
        /// تعداد تکرار سطح های خاکستری
        /// </summary>
        /// <returns>آرایه 256 تایی</returns>
        public static int[] IntensityGray(ref int[, ,] image, int width, int height)
        {
            int[] ints = new int[256];
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    ints[image[i, j, 0]]++;
                }
            }
            return ints;
        }
        /// <summary>
        /// تعداد تکرارهای آبی و قرمز و سبز
        /// </summary>
        /// <returns>آرایه 256 * 3 تایی</returns>
        public static int[,] colorsCount(ref int[, ,] image, int width, int height)
        {
            int[,] cCount = new int[3, 256];
            int rMax = 0, bMax = 0, gMax = 0;
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    int r = cCount[0, image[i, j, 0]]++; if (r > rMax) rMax = r;
                    int g = cCount[1, image[i, j, 1]]++; if (g > gMax) gMax = g;
                    int b = cCount[2, image[i, j, 2]]++; if (b > bMax) bMax = b;
                }
            }
            return cCount;
        }
        /// <summary>
        /// قابی که در اون مقدار 0 نباشه رو برمیگردونه
        /// </summary>
        /// <param name="imagematris"></param>
        /// <param name="width"></param>
        /// <param name="height"></param>
        /// <returns></returns>
        public static int[] ComponentFrame(ref int[,] imagematris, int width, int height)
        {
            int firstw = 0; for (int i = 0; i < width; i++) for (int j = 0; j < height; j++) if (imagematris[i, j] == 1) { firstw = i; i = width; break; }
            int lastw = 0; for (int i = width - 1; i >= 0; i--) for (int j = 0; j < height; j++) if (imagematris[i, j] == 1) { lastw = i; i = -1; break; }
            int firsth = 0; for (int j = 0; j < height; j++) for (int i = 0; i < width; i++) if (imagematris[i, j] == 1) { firsth = j; j = height; break; }
            int lasth = 0; for (int j = height - 1; j >= 0; j--) for (int i = 0; i < width; i++) if (imagematris[i, j] == 1) { lasth = j; j = -1; break; }
            return new int[] { firstw, firsth, lastw, lasth };
        }
        public static int[] ComponentFrame(ref int[, ,] imagematris, int width, int height)
        {
            int firstw = 0; for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                    if (imagematris[i, j, 0] != 0 || imagematris[i, j, 1] != 0 || imagematris[i, j, 2] != 0) 
                    { firstw = i; i = width; break; }
            int lastw = 0; for (int i = width - 1; i >= 0; i--) for (int j = 0; j < height; j++)
                    if (imagematris[i, j, 0] != 0 || imagematris[i, j, 1] != 0 || imagematris[i, j, 2] != 0) 
                { lastw = i; i = -1; break; }
            int firsth = 0; for (int j = 0; j < height; j++) for (int i = 0; i < width; i++)
                    if (imagematris[i, j, 0] != 0 || imagematris[i, j, 1] != 0 || imagematris[i, j, 2] != 0) 
                { firsth = j; j = height; break; }
            int lasth = 0; for (int j = height - 1; j >= 0; j--) for (int i = 0; i < width; i++)
                    if (imagematris[i, j, 0] != 0 || imagematris[i, j, 1] != 0 || imagematris[i, j, 2] != 0) 
                { lasth = j; j = -1; break; }
            return new int[] { firstw, firsth, lastw, lasth };
        }
        /// <summary>
        /// ماکس و مین و میانگین هر سه رنگ
        /// </summary>
        /// <returns>آرایه 3*3</returns>
        public static int[,] AvgColors(ref int[, ,] image, int width, int height)
        {
            int[,] infs = new int[3, 3];
            int rmin = 255, gmin = 255, bmin = 255, rmax = 0, gmax = 0, bmax = 0;

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    infs[0,1] += image[i, j, 0];
                    if (image[i, j, 0] < rmin) rmin = image[i, j, 0];
                    if (image[i, j, 0] > rmax) rmax = image[i, j, 0];
                    infs[1,1] += image[i, j, 1];
                    if (image[i, j, 1] < gmin) gmin = image[i, j, 1];
                    if (image[i, j, 1] > gmax) gmax = image[i, j, 1];
                    infs[2,1] += image[i, j, 2];
                    if (image[i, j, 2] < bmin) bmin = image[i, j, 2];
                    if (image[i, j, 2] > bmax) bmax = image[i, j, 2];
                }
            }
            infs[0, 0] = rmin;
            infs[0, 1] /= width * height;
            infs[0, 2] = rmax;
            infs[1, 0] = gmin;
            infs[1, 1] /= width * height;
            infs[1, 2] = gmax;
            infs[2, 0] = bmin;
            infs[2, 1] /= width * height;
            infs[2, 2] = bmax;

            return infs;
        }
        /// <summary>
        /// ماکس و مین و میانگین سطح خاکستری
        /// </summary>
        /// <returns>آرایه 3*1</returns>
        public static int[] AvgColorsGray(ref int[, ,] image, int width, int height)
        {
            int[] infs = new int[3];
            int min = 0, max = 0;
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    infs[0] += image[i, j, 0];
                    if (image[i, j, 0] < min) min = image[i, j, 0];
                    if (image[i, j, 0] > max) max = image[i, j, 0];
                }
            }
            infs[0] = min;
            infs[1] /= width * height;
            infs[2] = max;
            return infs;
        }
        /// <param name="image">original image</param>
        /// <param name="replaceImage">uses for 'filterType' = [replace,rep]</param>
        /// <param name="filterType">gray, black, rep, replace</param>
        public static void MaskByColor(ref int[, ,] image,ref int[,,]replaceImage, int width, int height, int r, int g, int b, int ErroreThreshold,string filterType)
        {
            switch (filterType)
            {
                case "gray":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            if (!(
                                System.Math.Abs(image[i, j, 0] - r) <= ErroreThreshold &&
                                System.Math.Abs(image[i, j, 1] - g) <= ErroreThreshold &&
                                System.Math.Abs(image[i, j, 2] - b) <= ErroreThreshold))
                                image[i, j, 0] = image[i, j, 1] = image[i, j, 2] = (image[i, j, 0] + image[i, j, 1] + image[i, j, 2]) / 3;
                            //{ image[i, j, 0] = 10; image[i, j, 1] = 10; image[i, j, 2] = 10; }
                    break;
                case "black":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            if (!(
                                System.Math.Abs(image[i, j, 0] - r) <= ErroreThreshold &&
                                System.Math.Abs(image[i, j, 1] - g) <= ErroreThreshold &&
                                System.Math.Abs(image[i, j, 2] - b) <= ErroreThreshold))
                            { image[i, j, 0] = 0; image[i, j, 1] = 0; image[i, j, 2] = 0; }
                    break;
                case "replace":
                case "rep":
                    for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                            if (!(
                                System.Math.Abs(replaceImage[i, j, 0] - r) <= ErroreThreshold &&
                                System.Math.Abs(replaceImage[i, j, 1] - g) <= ErroreThreshold &&
                                System.Math.Abs(replaceImage[i, j, 2] - b) <= ErroreThreshold))
                            { image[i, j, 0] = replaceImage[i, j, 0]; image[i, j, 1] = replaceImage[i, j, 1]; image[i, j, 2] = replaceImage[i, j, 2]; }
                    break;
            }
        }
        public static void StrechHistogram(ref int[, ,] image, int width, int height, string type, int lowera, int uppera, int lowerb, int upperb)
        {
            int s = 0;
            try
            {
                s = (uppera - lowera) / (upperb - lowerb);
            }
            catch { return; }

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    switch (type)
                    {
                        case "r": image[i, j, 0] = (image[i, j, 0] - lowerb) * s + lowera; break;
                        case "g": image[i, j, 1] = (image[i, j, 1] - lowerb) * s + lowera; break;
                        case "b": image[i, j, 2] = (image[i, j, 2] - lowerb) * s + lowera; break;
                        case "all":
                        case "a":
                            image[i, j, 0] = (image[i, j, 0] - lowerb) * s + lowera;
                            image[i, j, 1] = (image[i, j, 1] - lowerb) * s + lowera;
                            image[i, j, 2] = (image[i, j, 2] - lowerb) * s + lowera;
                            break;
                    }
                }
            }
        }
        public static void CutPixelRange(ref int[, ,] image, int width, int height, ref int[,] values)
        {
            for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                {
                    image[i, j, 0] = image[i, j, 0] <= values[0, 0] ? values[0, 1] : image[i, j, 0] >= values[0, 2] ? values[0, 3] : image[i, j, 0];
                    image[i, j, 1] = image[i, j, 1] <= values[1, 0] ? values[1, 1] : image[i, j, 1] >= values[1, 2] ? values[1, 3] : image[i, j, 1];
                    image[i, j, 2] = image[i, j, 2] <= values[2, 0] ? values[2, 1] : image[i, j, 2] >= values[2, 2] ? values[2, 3] : image[i, j, 2];
                }
        }

        public static double euiler(ref int[,] image, int width, int height)
        {
            int w=0;
            for (int i = 0; i < width; i++) for (int j = 0; j < height; j++)
                    if (image[i, j] == 1) w++;
            return Convert.ToDouble(w) / Convert.ToDouble(width * height);
        }
        public static int BestThresholdValue(ref int[, ,] image, int width, int height)
        {
            double[] eulerVals = new double[256];
            
            for (int i = 254; i > 0; i--)
            {
                int[,] _2dimage = Math.ApplyBinaryThreshold(ref image, width, height, i, 0);
                eulerVals[i] = Histogram.euiler(ref _2dimage, width, height);
            }
            double[] eulerVals_2 = new double[256];
            for (int i = 2; i < 254; i++) eulerVals_2[i] = eulerVals[i] - eulerVals[i - 1];

            double maxv = Convert.ToInt32(eulerVals_2[2]);
            int maxindex = 2;
            for (int i = 2; i < 254; i++)
            {
                if (eulerVals_2[i] > maxv)
                {
                    maxv = eulerVals_2[i];
                    maxindex = i;
                }
            }

            return maxindex;
        }
        public static int WorstThresholdValue(ref int[, ,] image, int width, int height)
        {
            double[] eulerVals = new double[256];

            for (int i = 254; i > 0; i--)
            {
                int[,] _2dimage = Math.ApplyBinaryThreshold(ref image, width, height, i, 0);
                eulerVals[i] = Histogram.euiler(ref _2dimage, width, height);
            }
            double[] eulerVals_2 = new double[256];
            for (int i = 2; i < 254; i++) eulerVals_2[i] = eulerVals[i] - eulerVals[i - 1];

            double minv = Convert.ToInt32(eulerVals_2[2]);
            int minindex = 2;
            for (int i = 2; i < 254; i++)
            {
                if (eulerVals_2[i] < minv)
                {
                    minv = eulerVals_2[i];
                    minindex = i;
                }
            }

            return minindex;
        }
        public static int BestThresholdValue(ref int[,] _2dimage, int width, int height)
        {
            double[] eulerVals = new double[256];

            for (int i = 254; i > 0; i--)
            {
                Math.ApplyThreshold(ref _2dimage, width, height, i, 0);
                eulerVals[i] = Histogram.euiler(ref _2dimage, width, height);
            }
            double[] eulerVals_2 = new double[256];
            for (int i = 1; i < 256; i++) eulerVals_2[i] = eulerVals[i] - eulerVals[i - 1];

            double maxv = 0;
            int maxindex = 0;
            for (int i = 0; i < 256; i++)
            {
                if (eulerVals_2[i] > maxv)
                {
                    maxv = eulerVals_2[i];
                    maxindex = i;
                }
            }

            return maxindex;
        }

        public static void Normalize_(ref int[, ,] image, int width, int height, int mode)
        {
            switch(mode){
                case 0:
                    {
                        for (int i = 0; i < width; i++)
                            for (int j = 0; j < height; j++)
                            {
                                int r = image[i, j, 0], g = image[i, j, 1], b = image[i, j, 2];
                                double rgb = r + g + b;
                                image[i, j, 0] = r == 0 ? 0 : Convert.ToInt32(Convert.ToDouble(r) / rgb * 255);
                                image[i, j, 1] = g == 0 ? 0 : Convert.ToInt32(Convert.ToDouble(g) / rgb * 255);
                                image[i, j, 2] = b == 0 ? 0 : Convert.ToInt32(Convert.ToDouble(b) / rgb * 255);
                            }
                        break;
                    }
                case 1:
                    {
                        for (int i = 0; i < width; i++)
                            for (int j = 0; j < height; j++)
                            {
                                int r = image[i, j, 0], g = image[i, j, 1], b = image[i, j, 2];
                                double rgb = r + g + b;
                                image[i, j, 0] = Convert.ToInt32(Convert.ToDouble(r) / rgb) * 255;
                                image[i, j, 1] = Convert.ToInt32(Convert.ToDouble(g) / rgb) * 255;
                                image[i, j, 2] = Convert.ToInt32(Convert.ToDouble(b) / rgb) * 255;
                            }
                        break;
                    }
            }
            Math.ApplyThreshold(ref image, width, height, 255, 0);
        }
    }

    public static class Logic
    {
        /// <summary>
        /// its possible that matris dosn't contain only{0,1}  ! it can be any num, but i just nead {0,1}.
        /// </summary>
        public static void AND(ref int[,] mat1, ref int[,] mat2, ref int[,] mat3, int w, int h)
        {
            for (int i = 0; i < w; i++) for (int j = 0; j < h; j++) mat3[i, j] = mat1[i, j] == 1 ? mat2[i, j] == 1 ? 1 : 0 : 0;
        }
        public static void OR(ref int[,] mat1, ref int[,] mat2, ref int[,] mat3, int w, int h)
        {
            for (int i = 0; i < w; i++) for (int j = 0; j < h; j++) mat3[i, j] = mat1[i, j] == 1 ? 1 : mat2[i, j] == 1 ? 1 : 0;
        }
        public static void NOT_(ref int[,] mat, int w, int h)
        {
            for (int i = 0; i < w; i++) for (int j = 0; j < h; j++) mat[i, j] = mat[i, j] == 0 ? 1 : 0;
        }
        public static int[,] NOT(ref int[,] mat, int w, int h)
        {
            int[,] newmat = new int[w, h];
            for (int i = 0; i < w; i++) for (int j = 0; j < h; j++) newmat[i, j] = mat[i, j] == 0 ? 1 : 0;
            return newmat;
        }

        public static bool AreEqual(ref int[,] mat1, ref int[,] mat2, int w, int h)
        {

            for (int i = 0; i < w; i++) for (int j = 0; j < h; j++) if (mat1[i, j] != mat2[i, j]) return false;
            return true;
        }
    }

    public static class Filters
    {
        public static int[, ,] cleannoise(ref int[, ,] image, int width, int height, string operation, int winsize)
        {
            int[, ,] newimage = new int[width + 2 * winsize, height + 2 * winsize, 3];
            image = Matris.Edit.ExpandAndCentralize(ref image, width, height, winsize);

            int maxwin = ((winsize - 1) / 2);
            int center = maxwin + 1;
            int minwin = -maxwin;
            int maxwidth = width - maxwin;
            int maxheight = height - maxwin;
            int winpixs = winsize * winsize;

            for (int i = winsize; i < width + winsize; i++)
            {
                for (int j = winsize; j < height + winsize; j++)
                {
                    int[] r = new int[winpixs];
                    int[] g = new int[winpixs];
                    int[] b = new int[winpixs];
                    int finalr = 0, finalg = 0, finalb = 0;
                    int[, ,] nhoods = Matris.Load.NHOODS_3D_(ref image, winsize, i, j);
                    for (int ii = 0; ii < winsize; ii++) for (int jj = 0; jj < winsize; jj++)
                        { r[ii * winsize + jj] = nhoods[ii, jj, 0]; g[ii * winsize + jj] = nhoods[ii, jj, 1]; b[ii * winsize + jj] = nhoods[ii, jj, 2]; }

                    switch (operation)
                    {
                        case "max":
                            finalr = r.Max();
                            finalg = g.Max();
                            finalb = b.Max();
                            break;
                        case "min":
                            finalr = r.Min();
                            finalg = g.Min();
                            finalb = b.Min();
                            break;
                        case "avg":
                        case "smoothing":
                            finalr = Convert.ToInt16(r.Average());
                            finalg = Convert.ToInt16(g.Average());
                            finalb = Convert.ToInt16(b.Average());
                            break;
                        case "directionalsmoothing":
                        case "dir":
                            int[] _r = new int[4], _g = new int[4], _b = new int[4];
                            //left to right
                            for (int ii = 0; ii < winsize; ii++)
                            { _r[0] += nhoods[ii, maxwin, 0]; _g[0] += nhoods[ii, maxwin, 1]; _b[0] += nhoods[ii, maxwin, 2]; }
                            //down to top
                            for (int ii = 0; ii < winsize; ii++)
                            { _r[1] += nhoods[maxwin, ii, 0]; _g[1] += nhoods[maxwin, ii, 1]; _b[1] += nhoods[maxwin, ii, 2]; }
                            //downright to topleft
                            for (int ii = 0; ii < winsize; ii++) { _r[2] += nhoods[ii, ii, 0]; _g[2] += nhoods[ii, ii, 1]; _b[2] += nhoods[ii, ii, 2]; }
                            //downleft to topright
                            for (int ii = 0; ii < winsize; ii++)
                            { _r[3] += nhoods[ii, winsize - ii - 1, 0]; _g[3] += nhoods[ii, winsize - ii - 1, 1]; _b[3] += nhoods[ii, winsize - ii - 1, 2]; }
                            //min
                            int finalr_index = 0, finalr_min = 256;
                            for (int ii = 0; ii < 4; ii++)
                            {
                                _r[ii] /= winsize;
                                if (System.Math.Abs(nhoods[center, center, 0] - _r[ii]) < finalr_min)
                                { finalr_min = System.Math.Abs(nhoods[center, center, 0] - _r[ii]); finalr_index = ii; }
                            }
                            int finalg_index = 0, finalg_min = 256;
                            for (int ii = 0; ii < 4; ii++)
                            {
                                _g[ii] /= winsize;
                                if (System.Math.Abs(nhoods[center, center, 1] - _g[ii]) < finalg_min)
                                { finalg_min = System.Math.Abs(nhoods[center, center, 1] - _g[ii]); finalg_index = ii; }
                            }
                            int finalb_index = 0, finalb_min = 256;
                            for (int ii = 0; ii < 4; ii++)
                            {
                                _b[ii] /= winsize;
                                if (System.Math.Abs(nhoods[center, center, 2] - _b[ii]) < finalb_min)
                                { finalb_min = System.Math.Abs(nhoods[center, center, 2] - _b[ii]); finalb_index = ii; }
                            }
                            finalr = _r[finalr_index];
                            finalg = _g[finalg_index];
                            finalb = _b[finalb_index];
                            break;
                        case "median":
                            mspsort(ref r, winpixs);
                            finalr = r[winpixs / 2];
                            mspsort(ref g, winpixs);
                            finalg = g[winpixs / 2];
                            mspsort(ref b, winpixs);
                            finalb = b[winpixs / 2];
                            break;
                    }
                    newimage[i, j, 0] = finalr;
                    newimage[i, j, 1] = finalg;
                    newimage[i, j, 2] = finalb;
                }
            }

            Matris.Math.ApplyThreshold(ref newimage, width + 2 * winsize, height + 2 * winsize, 255, 0);
            newimage = Matris.Edit.Crop(ref newimage, width + 2 * winsize, height + 2 * winsize,
                winsize, winsize, width + winsize, height + winsize);
            return newimage;
        }
        public static void mspsort(ref int[] list, int length)
        {
            for (int i = length - 2; i >= 0; i--)
            {
                for (int j = i; j < length - 1 && list[j] > list[j + 1]; j++)
                {
                    int temp = list[j + 1];
                    list[j + 1] = list[j];
                    list[j] = temp;
                }
            }
        }
        public static void MSPcontrast16(ref int[, ,] image, int width, int height)
        {
            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    int r = image[i, j, 0];
                    int g = image[i, j, 1];
                    int b = image[i, j, 2];
                    r = r > 64 ? r > 127 ? r > 192 ? 255 : 127 : 64 : 0;
                    g = g > 64 ? g > 127 ? g > 192 ? 255 : 127 : 64 : 0;
                    b = b > 64 ? b > 127 ? b > 192 ? 255 : 127 : 64 : 0;
                    image[i, j, 0] = r;
                    image[i, j, 1] = g;
                    image[i, j, 2] = b;
                }
            }
        }
        public static int[, ,] yekdast(ref int[, ,] imagematris, int width, int height)
        {
            int[, ,] newimagematris = new int[width, height, 3];

            int[] r = new int[256];
            int[] g = new int[256];
            int[] b = new int[256];
            int[] intensity = new int[256];
            Queue<Point>[] SameColors = new Queue<Point>[256];
            for (int i = 0; i < 256; i++) SameColors[i] = new Queue<Point>();

            for (int x = 0; x < width; x++)
            {
                for (int y = 0; y < height; y++)
                {
                    double intens =
                        0.2125 * Convert.ToDouble(imagematris[x, y, 0]) +
                        0.7154 * Convert.ToDouble(imagematris[x, y, 1]) +
                        0.0721 * Convert.ToDouble(imagematris[x, y, 2]);

                    intensity[Convert.ToInt32(intens)]++;
                    r[Convert.ToInt32(intens)] += imagematris[x, y, 0];
                    g[Convert.ToInt32(intens)] += imagematris[x, y, 1];
                    b[Convert.ToInt32(intens)] += imagematris[x, y, 2];
                    SameColors[Convert.ToInt32(intens)].Enqueue(new Point(x, y));
                }
            }

            //rebuild image
            Point tmp = new Point(0, 0);
            int R = 0, G = 0, B = 0, In = 0;
            for (int i = 0; i < 256; i++)
            {
                In = intensity[i];
                R = In == 0 ? 0 : r[i] / In;
                G = In == 0 ? 0 : g[i] / In;
                B = In == 0 ? 0 : b[i] / In;

                while (SameColors[i].Count != 0)
                {
                    tmp = SameColors[i].Dequeue();
                    newimagematris[tmp.X, tmp.Y, 0] = R;
                    newimagematris[tmp.X, tmp.Y, 1] = G;
                    newimagematris[tmp.X, tmp.Y, 2] = B;
                }
            }

            Matris.Math.ApplyThreshold(ref newimagematris, width, height, 255, 0);
            return newimagematris;
        }
        public static int[, ,] ApplyFilter_(ref int[, ,] imagematris, int width, int height, int[,] filter, int filtersize, int filterZarib)
        {
            int[, ,] newimagematris = new int[width, height, 3];
            Matris.Math.ApplyFilter(ref imagematris, width, height, ref newimagematris, Matris.Load.Matris3DFromeMatris2D(filter, filtersize, filtersize), filtersize);
            Matris.Math.devide(ref newimagematris, width, height, filterZarib);
            Matris.Math.ApplyThreshold(ref newimagematris, width, height, 255, 0);
            return newimagematris;
        }//apply user defined filter
    }

    public static class Arts
    {
        public static void Jitter(ref int[, ,] imagematris, int width, int height, int winsize)
        {
            Random rand = new Random();
            int winrad = (winsize - 1) / 2;

            int[, ,] newimagematris = new int[width, height, 3];
            for (int i = 0; i < width; i++) for (int j = 0; j < height; j++) for (int k = 0; k < 3; k++)
                        newimagematris[i, j, k] = imagematris[i, j, k];

            for (int i = 0; i < width; i++)
            {
                for (int j = 0; j < height; j++)
                {
                    int xinc = rand.Next(winsize) - winrad; xinc = i + xinc < 0 ? -i : i + xinc > width - 1 ? width - 1 - i : xinc;
                    int yinc = rand.Next(winsize) - winrad; yinc = j + yinc < 0 ? -j : j + yinc > height - 1 ? height - 1 - j : yinc;

                    newimagematris[i + xinc, j + yinc, 0] = imagematris[i, j, 0];
                    newimagematris[i + xinc, j + yinc, 1] = imagematris[i, j, 1];
                    newimagematris[i + xinc, j + yinc, 2] = imagematris[i, j, 2];
                }
            }
            imagematris = newimagematris;
        }
    }

}//name space matris